using System;

namespace gov.va.med.vbecs.DAL.VistALink.OpenLibrary
{
	/// <summary>
	/// This exception is thrown when server returns fault message indicating that 
	/// logis are disabled on M server and it cannot allow client to start a session.
	/// This exception is fatal - VistALink connection is dropped before the exception is thrown.
	/// </summary>
	public class LoginsDisabledException : SystemFaultException
	{
		/// <summary>
		/// This constructor accepts fault info object containing 
		/// information about a fault occured at server side.
		/// </summary>
		/// <param name="faultInfo">
		///		Fault info object containing information about a fault
		///		occured at server side.
		///	</param>
		public LoginsDisabledException( FaultInfo faultInfo )
			: base( faultInfo, true ) {}
	}
}
